<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PurchaseBill extends Model 
{

    protected $table = 'purchase_bills';
    public $timestamps = true;
    protected $fillable = array('supplier_id', 'bill_number', 'user_id');

    public function supplier()
    {
        return $this->belongsTo('App\Models\Supplier');
    }

    public function products()
    {
        return $this->belongsToMany('App\Models\Product')->withPivot('price','quantity','subunit');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

}